/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Solve an Eikonal equation using Fast Marching.


Fast marching solves an Eikonal equation where the speed is always
non-negative and depends on the position only. Starting from an
initial position on the front, fast marching systematically moves the
front forward one grid point at a time.

Updates are performed using an entropy satisfy scheme where only
"upwind" neighborhoods are used. This implementation of Fast
Marching uses a std::priority_queue to locate the next proper grid
position to update.

Fast Marching sweeps through N grid points in (N log N) steps to
obtain the arrival time value as the front propagates through the
grid.

Implementation of this class is based on Chapter 8 of "Level Set
Methods and Fast Marching Methods", J.A. Sethian, Cambridge Press,
Second edition, 1999.

This class is templated over the level set image type and the speed
image type. The initial front is specified by two containers: one
containing the known points and one containing the trial points. Alive
points are those that are already part of the object, and trial points
are considered for inclusion. In order for the filter to evolve, at
least some trial points must be specified. These can for instance be
specified as the layer of pixels around the alive points.

The speed function can be specified as a speed image or a speed
constant. The speed image is set using the method SetInput() . If the
speed image is nullptr, a constant speed function is used and is
specified using method the SetSpeedConstant() .

If the speed function is constant and of value one, fast marching
results in an approximate distance function from the initial alive
points. FastMarchingImageFilter is used in the ReinitializeLevelSetImageFilter object to create a signed distance function from the zero level set.

The algorithm can be terminated early by setting an appropriate
stopping value. The algorithm terminates when the current arrival time
being processed is greater than the stopping value.

There are two ways to specify the output image information (
LargestPossibleRegion, Spacing, Origin): (a) it is copied directly
from the input speed image or (b) it is specified by the user. Default
values are used if the user does not specify all the information.

The output information is computed as follows. If the speed image is
nullptr or if the OverrideOutputInformation is set to true, the output
information is set from user specified parameters. These parameters
can be specified using methods SetOutputRegion() , SetOutputSpacing()
, SetOutputDirection() , and SetOutputOrigin() . Else if the speed
image is not nullptr, the output information is copied from the input
speed image.

For an alternative implementation, see itk::FastMarchingImageFilter .

Possible Improvements: In the current implementation,
std::priority_queue only allows taking nodes out from the front and
putting nodes in from the back. To update a value already on the heap,
a new node is added to the heap. The defunct old node is left on the
heap. When it is removed from the top, it will be recognized as
invalid and not used. Future implementations can implement the heap in
a different way allowing the values to be updated. This will generally
require some sift-up and sift-down functions and an image of back-
pointers going from the image to heap in order to locate the node
which is to be updated.


See:
 FastMarchingImageFilterBase

 LevelSetTypeDefault

 itk::simple::FastMarching for the procedural interface

 itk::FastMarchingImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkFastMarchingImageFilter.h
*/
public class FastMarchingImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected FastMarchingImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.FastMarchingImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(FastMarchingImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(FastMarchingImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::FastMarchingImageFilter::~FastMarchingImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_FastMarchingImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::FastMarchingImageFilter::FastMarchingImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  FastMarchingImageFilter() {
    this(SimpleITKJNI.new_FastMarchingImageFilter(), true);
  }

  /**
Self&amp; itk::simple::FastMarchingImageFilter::SetTrialPoints(std::vector&lt; std::vector&lt; unsigned int &gt; &gt; TrialPoints)

Set the container of Trial Points representing the initial front.
Trial points are represented as a VectorContainer of LevelSetNodes.

*/
public  void setTrialPoints(VectorUIntList TrialPoints) {
    SimpleITKJNI.FastMarchingImageFilter_setTrialPoints(swigCPtr, this, VectorUIntList.getCPtr(TrialPoints), TrialPoints);
  }

  /**
std::vector&lt; std::vector&lt; unsigned int &gt; &gt; itk::simple::FastMarchingImageFilter::GetTrialPoints() const

Get the container of Trial Points representing the initial front.

*/
public  VectorUIntList getTrialPoints() {
    return new VectorUIntList(SimpleITKJNI.FastMarchingImageFilter_getTrialPoints(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::FastMarchingImageFilter::AddTrialPoint(std::vector&lt; unsigned int &gt; point)

Add TrialPoints point.

*/
public  void addTrialPoint(VectorUInt32 point) {
    SimpleITKJNI.FastMarchingImageFilter_addTrialPoint(swigCPtr, this, VectorUInt32.getCPtr(point), point);
  }

  /**
Self&amp; itk::simple::FastMarchingImageFilter::ClearTrialPoints()

Remove all TrialPoints points.

*/
public  void clearTrialPoints() {
    SimpleITKJNI.FastMarchingImageFilter_clearTrialPoints(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::FastMarchingImageFilter::SetNormalizationFactor(double NormalizationFactor)

Set/Get the Normalization Factor for the Speed Image . The values in the Speed Image is divided by this factor. This allows the use of images with integer
pixel types to represent the speed.

*/
public  void setNormalizationFactor(double NormalizationFactor) {
    SimpleITKJNI.FastMarchingImageFilter_setNormalizationFactor(swigCPtr, this, NormalizationFactor);
  }

  /**
double itk::simple::FastMarchingImageFilter::GetNormalizationFactor() const

Set/Get the Normalization Factor for the Speed Image . The values in the Speed Image is divided by this factor. This allows the use of images with integer
pixel types to represent the speed.

*/
public  double getNormalizationFactor() {
    return SimpleITKJNI.FastMarchingImageFilter_getNormalizationFactor(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::FastMarchingImageFilter::SetStoppingValue(double StoppingValue)

Set the Fast Marching algorithm Stopping Value. The Fast Marching
algorithm is terminated when the value of the smallest trial point is
greater than the stopping value.

*/
public  void setStoppingValue(double StoppingValue) {
    SimpleITKJNI.FastMarchingImageFilter_setStoppingValue(swigCPtr, this, StoppingValue);
  }

  /**
double itk::simple::FastMarchingImageFilter::GetStoppingValue() const

Get the Fast Marching algorithm Stopping Value.

*/
public  double getStoppingValue() {
    return SimpleITKJNI.FastMarchingImageFilter_getStoppingValue(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::FastMarchingImageFilter::SetInitialTrialValues(std::vector&lt; double &gt; InitialTrialValues)

Set the initial seed values for corresponding trial points.

*/
public  void setInitialTrialValues(VectorDouble InitialTrialValues) {
    SimpleITKJNI.FastMarchingImageFilter_setInitialTrialValues(swigCPtr, this, VectorDouble.getCPtr(InitialTrialValues), InitialTrialValues);
  }

  /**
std::vector&lt;double&gt; itk::simple::FastMarchingImageFilter::GetInitialTrialValues() const
*/
public  VectorDouble getInitialTrialValues() {
    return new VectorDouble(SimpleITKJNI.FastMarchingImageFilter_getInitialTrialValues(swigCPtr, this), true);
  }

  /**
std::string itk::simple::FastMarchingImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.FastMarchingImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::FastMarchingImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.FastMarchingImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::FastMarchingImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.FastMarchingImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
