/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc;

import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.logging.Level;
import javax.inject.Inject;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import oracle.ucp.UniversalConnectionPoolAdapter;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.admin.UniversalConnectionPoolManagerMBean;
import oracle.ucp.admin.UniversalConnectionPoolManagerMBeanImpl;
import oracle.ucp.diagnostics.DiagnosticsCollectorImpl;
import oracle.ucp.jdbc.PoolDataSource;
import oracle.ucp.jdbc.PoolDataSourceFactory;
import oracle.ucp.jdbc.UCPDataSourceResource;
import oracle.ucp.jdbc.UCPResource;

public class UCPServletContextListener
implements ServletContextListener {
    static final String CLASS_NAME = UCPServletContextListener.class.getName();
    private PoolDataSource pds;
    private InitialContext initContext;
    private UniversalConnectionPoolManagerMBean managerMBean;
    @Inject
    @UCPResource
    private UCPDataSourceResource ucpDataSourceResource;

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        ServletContext context = servletContextEvent.getServletContext();
        this.initializeUCPDataSourceResource(context);
        if (this.ucpDataSourceResource == null) {
            return;
        }
        try {
            this.configureUCPDataSource(context);
            if (this.pds == null || this.pds.getURL() == null || this.pds.getConnectionFactoryClassName() == null || "".equals(this.pds.getConnectionFactoryClassName())) {
                this.pds = null;
                return;
            }
            this.startPool();
            this.ucpDataSourceResource.setPoolDataSource(this.pds);
            this.bindUCPDatasourceResource(context);
        }
        catch (SQLException | NamingException | UniversalConnectionPoolException exception) {
            DiagnosticsCollectorImpl.getCommon().trace(Level.WARNING, CLASS_NAME, "contextInitialized", "", null, exception, new Object[0]);
            this.cleanupPool();
        }
        catch (Throwable exception) {
            DiagnosticsCollectorImpl.getCommon().trace(Level.WARNING, CLASS_NAME, "contextInitialized", "", null, exception, new Object[0]);
            this.cleanupPool();
        }
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        ServletContext context = servletContextEvent.getServletContext();
        this.removeBinding(context);
        this.cleanupPool();
    }

    private void initializeUCPDataSourceResource(ServletContext context) {
        if (this.ucpDataSourceResource == null && context.getInitParameter("ucp.jndiName") != null) {
            this.ucpDataSourceResource = new UCPDataSourceResource();
        }
    }

    private void configureUCPDataSource(ServletContext context) throws SQLException {
        if (System.getProperty("oracle.ucp.jdbc.xmlConfigFile") != null && context.getInitParameter("ucp.dataSourceNameFromXMLConfig") != null) {
            this.pds = PoolDataSourceFactory.getPoolDataSource(context.getInitParameter("ucp.dataSourceNameFromXMLConfig"));
        } else {
            this.pds = PoolDataSourceFactory.getPoolDataSource();
            Enumeration parameterNames = context.getInitParameterNames();
            while (parameterNames.hasMoreElements()) {
                String parameter = (String)parameterNames.nextElement();
                try {
                    Class parameterType = null;
                    Object value = null;
                    switch (parameter) {
                        case "ucp.connectionPoolName": 
                        case "ucp.connectionFactoryClassName": 
                        case "ucp.URL": 
                        case "ucp.user": 
                        case "ucp.password": 
                        case "ucp.serverName": 
                        case "ucp.databaseName": 
                        case "ucp.dataSourceName": 
                        case "ucp.description": 
                        case "ucp.networkProtocol": 
                        case "ucp.roleName": 
                        case "ucp.sqlForValidateConnection": 
                        case "ucp.onsConfiguration": {
                            parameterType = String.class;
                            value = context.getInitParameter(parameter);
                            break;
                        }
                        case "ucp.portNumber": 
                        case "ucp.initialPoolSize": 
                        case "ucp.maxPoolSize": 
                        case "ucp.minPoolSize": 
                        case "ucp.abandonedConnectionTimeout": 
                        case "ucp.timeToLiveConnectionTimeout": 
                        case "ucp.inactiveConnectionTimeout": 
                        case "ucp.maxIdleTime": 
                        case "ucp.timeoutCheckInterval": 
                        case "ucp.propertyCycle": 
                        case "ucp.maxStatements": 
                        case "ucp.connectionWaitTimeout": 
                        case "ucp.maxConnectionReuseCount": 
                        case "ucp.connectionHarvestTriggerCount": 
                        case "ucp.connectionHarvestMaxCount": 
                        case "ucp.secondsToTrustIdleConnection": 
                        case "ucp.connectionLabelingHighCost": 
                        case "ucp.connectionRepurposeThreshold": 
                        case "ucp.highCostConnectionReuseThreshold": 
                        case "ucp.maxConnectionsPerShard": 
                        case "ucp.connectionValidationTimeout": {
                            parameterType = Integer.TYPE;
                            value = Integer.valueOf(context.getInitParameter(parameter));
                            break;
                        }
                        case "ucp.maxConnectionReuseTime": {
                            parameterType = Long.TYPE;
                            value = Long.valueOf(context.getInitParameter(parameter));
                            break;
                        }
                        case "ucp.validateConnectionOnBorrow": 
                        case "ucp.fastConnectionFailoverEnabled": 
                        case "ucp.shardingMode": {
                            parameterType = Boolean.TYPE;
                            value = Boolean.valueOf(context.getInitParameter(parameter));
                        }
                    }
                    if (parameterType == null) continue;
                    PoolDataSource.class.getMethod("set" + parameter.substring(4, 5).toUpperCase() + parameter.substring(5), parameterType).invoke((Object)this.pds, value);
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                    DiagnosticsCollectorImpl.getCommon().trace(Level.WARNING, CLASS_NAME, "configureUCPDataSource", "", null, exception, new Object[0]);
                }
                catch (Throwable t) {
                    DiagnosticsCollectorImpl.getCommon().trace(Level.WARNING, CLASS_NAME, "configureUCPDataSource", "Error occurred while setting UCP pool datasource property : {0}", null, t, parameter);
                }
            }
        }
    }

    private void startPool() throws UniversalConnectionPoolException {
        this.managerMBean = UniversalConnectionPoolManagerMBeanImpl.getUniversalConnectionPoolManagerMBean();
        this.managerMBean.createConnectionPool((UniversalConnectionPoolAdapter)((Object)this.pds));
        this.managerMBean.startConnectionPool(this.pds.getConnectionPoolName());
    }

    private void bindUCPDatasourceResource(ServletContext context) throws NamingException {
        if (context.getInitParameter("ucp.jndiName") != null) {
            this.initContext = new InitialContext();
            this.initContext.bind(context.getInitParameter("ucp.jndiName"), (Object)this.ucpDataSourceResource);
        }
    }

    private void removeBinding(ServletContext context) {
        String ucpJndiName = context.getInitParameter("ucp.jndiName");
        if (this.initContext != null && ucpJndiName != null) {
            try {
                this.initContext.unbind(ucpJndiName);
            }
            catch (NamingException e) {
                DiagnosticsCollectorImpl.getCommon().trace(Level.WARNING, CLASS_NAME, "removeBinding", "", null, e, new Object[0]);
            }
        }
    }

    private void cleanupPool() {
        try {
            if (this.managerMBean == null || this.pds == null) {
                return;
            }
            this.managerMBean.stopConnectionPool(this.pds.getConnectionPoolName());
            this.managerMBean.destroyConnectionPool(this.pds.getConnectionPoolName());
        }
        catch (Throwable exception) {
            DiagnosticsCollectorImpl.getCommon().trace(Level.WARNING, CLASS_NAME, "cleanupPool", "", null, exception, new Object[0]);
        }
        finally {
            this.pds = null;
        }
    }
}

