/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.resources;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.DocWriteRequest;
import org.opensearch.action.DocWriteResponse;
import org.opensearch.action.StepListener;
import org.opensearch.action.admin.indices.create.CreateIndexRequest;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.index.IndexRequestBuilder;
import org.opensearch.action.search.ClearScrollRequest;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchScrollRequest;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.engine.VersionConflictEngineException;
import org.opensearch.index.query.AbstractQueryBuilder;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.MatchAllQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.script.Script;
import org.opensearch.script.ScriptType;
import org.opensearch.search.Scroll;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.security.spi.resources.sharing.CreatedBy;
import org.opensearch.security.spi.resources.sharing.Recipients;
import org.opensearch.security.spi.resources.sharing.ResourceSharing;
import org.opensearch.security.spi.resources.sharing.ShareWith;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.client.Client;

public class ResourceSharingIndexHandler {
    private static final Logger LOGGER = LogManager.getLogger(ResourceSharingIndexHandler.class);
    private final Client client;
    private final ThreadPool threadPool;
    public static final Map<String, Object> INDEX_SETTINGS = Map.of("index.number_of_shards", 1, "index.auto_expand_replicas", "0-all", "index.hidden", "true");

    @Inject
    public ResourceSharingIndexHandler(Client client, ThreadPool threadPool) {
        this.client = client;
        this.threadPool = threadPool;
    }

    public void createResourceSharingIndicesIfAbsent(Set<String> resourceIndices) {
        try (ThreadContext.StoredContext ctx = this.threadPool.getThreadContext().stashContext();){
            for (String resourceIndex : resourceIndices) {
                String resourceSharingIndex = ResourceSharingIndexHandler.getSharingIndex(resourceIndex);
                CreateIndexRequest cir = new CreateIndexRequest(resourceSharingIndex).settings(INDEX_SETTINGS).waitForActiveShards(1);
                ActionListener cirListener = ActionListener.wrap(response -> {
                    ctx.restore();
                    LOGGER.info("Resource sharing index {} created.", (Object)resourceSharingIndex);
                }, failResponse -> LOGGER.info("Index {} already exists.", (Object)resourceSharingIndex));
                this.client.admin().indices().create(cir, cirListener);
            }
        }
    }

    public static String getSharingIndex(String resourceIndex) {
        return resourceIndex + "-sharing";
    }

    public void indexResourceSharing(String resourceId, String resourceIndex, CreatedBy createdBy, ShareWith shareWith, ActionListener<ResourceSharing> listener) throws IOException {
        String resourceSharingIndex = ResourceSharingIndexHandler.getSharingIndex(resourceIndex);
        try (ThreadContext.StoredContext ctx = this.threadPool.getThreadContext().stashContext();){
            ResourceSharing entry = new ResourceSharing(resourceId, createdBy, shareWith);
            IndexRequest ir = (IndexRequest)((IndexRequestBuilder)this.client.prepareIndex(resourceSharingIndex).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).setSource(entry.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS)).setOpType(DocWriteRequest.OpType.CREATE).setId(resourceId).request();
            ActionListener irListener = ActionListener.wrap(idxResponse -> {
                ctx.restore();
                LOGGER.info("Successfully created {} entry for resource {} in index {}.", (Object)resourceSharingIndex, (Object)resourceId, (Object)resourceIndex);
                listener.onResponse((Object)entry);
            }, e -> {
                if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof VersionConflictEngineException) {
                    LOGGER.debug("Entry for [{}] already exists in [{}], skipping", (Object)resourceId, (Object)resourceSharingIndex);
                    listener.onResponse((Object)entry);
                } else {
                    LOGGER.error("Failed to create entry in [{}] for resource [{}]", (Object)resourceSharingIndex, (Object)resourceId, e);
                    listener.onFailure(e);
                }
            });
            this.client.index(ir, irListener);
        }
    }

    public void fetchAllResourceIds(String resourceIndex, ActionListener<Set<String>> listener) {
        String resourceSharingIndex = ResourceSharingIndexHandler.getSharingIndex(resourceIndex);
        LOGGER.debug("Fetching all documents asynchronously from {}", (Object)resourceSharingIndex);
        Scroll scroll = new Scroll(TimeValue.timeValueMinutes((long)1L));
        try (ThreadContext.StoredContext ctx = this.threadPool.getThreadContext().stashContext();){
            SearchRequest searchRequest = new SearchRequest(new String[]{resourceSharingIndex});
            searchRequest.scroll(scroll);
            MatchAllQueryBuilder query = QueryBuilders.matchAllQuery();
            this.executeSearchRequest(scroll, searchRequest, (AbstractQueryBuilder<? extends AbstractQueryBuilder<?>>)query, (ActionListener<Set<String>>)ActionListener.wrap(resourceIds -> {
                ctx.restore();
                LOGGER.debug("Found {} documents in {}", (Object)resourceIds.size(), (Object)resourceSharingIndex);
                listener.onResponse(resourceIds);
            }, exception -> {
                LOGGER.error("Search failed while locating all records inside resourceIndex={} ", (Object)resourceIndex, exception);
                listener.onFailure(exception);
            }));
        }
    }

    public void fetchAccessibleResourceIds(String resourceIndex, Set<String> entities, BoolQueryBuilder actionGroupQuery, ActionListener<Set<String>> listener) {
        Scroll scroll = new Scroll(TimeValue.timeValueMinutes((long)1L));
        String resourceSharingIndex = ResourceSharingIndexHandler.getSharingIndex(resourceIndex);
        try (ThreadContext.StoredContext ctx = this.threadPool.getThreadContext().stashContext();){
            SearchRequest searchRequest = new SearchRequest(new String[]{resourceSharingIndex});
            searchRequest.scroll(scroll);
            BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
            boolQuery.must((QueryBuilder)actionGroupQuery);
            this.executeFlattenedSearchRequest(scroll, searchRequest, boolQuery, (ActionListener<Set<String>>)ActionListener.wrap(resourceIds -> {
                ctx.restore();
                LOGGER.debug("Found {} documents matching the criteria in {}", (Object)resourceIds.size(), (Object)resourceSharingIndex);
                listener.onResponse(resourceIds);
            }, exception -> {
                LOGGER.error("Search failed for resourceIndex={}, entities={}", (Object)resourceIndex, (Object)entities, exception);
                listener.onFailure(exception);
            }));
        }
    }

    public void fetchSharingInfo(String resourceIndex, String resourceId, ActionListener<ResourceSharing> listener) {
        if (StringUtils.isBlank((CharSequence)resourceIndex) || StringUtils.isBlank((CharSequence)resourceId)) {
            listener.onFailure((Exception)new IllegalArgumentException("resourceIndex and resourceId must not be null or empty"));
            return;
        }
        String resourceSharingIndex = ResourceSharingIndexHandler.getSharingIndex(resourceIndex);
        LOGGER.debug("Fetching document from {}, matching resource_id: {}", (Object)resourceSharingIndex, (Object)resourceId);
        try (ThreadContext.StoredContext ctx = this.threadPool.getThreadContext().stashContext();){
            GetRequest getRequest = new GetRequest(resourceSharingIndex).id(resourceId);
            this.client.get(getRequest, ActionListener.wrap(getResponse -> {
                ctx.restore();
                try {
                    if (!getResponse.isExists()) {
                        LOGGER.debug("No document found in {} matching resource_id: {} and source_idx {}", (Object)resourceSharingIndex, (Object)resourceId, (Object)resourceIndex);
                        listener.onResponse(null);
                        return;
                    }
                    try (XContentParser parser = XContentType.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, getResponse.getSourceAsString());){
                        parser.nextToken();
                        ResourceSharing resourceSharing = ResourceSharing.fromXContent((XContentParser)parser);
                        resourceSharing.setResourceId(getResponse.getId());
                        LOGGER.debug("Successfully fetched document from {} matching resource_id: {} and source_idx: {}", (Object)resourceSharingIndex, (Object)resourceId, (Object)resourceIndex);
                        listener.onResponse((Object)resourceSharing);
                    }
                }
                catch (Exception e) {
                    String failureResponse = "Failed to parse document matching resource_id: " + resourceId + " and source_idx: " + resourceIndex + " from " + resourceSharingIndex;
                    LOGGER.error(failureResponse, (Throwable)e);
                    listener.onFailure((Exception)new OpenSearchStatusException(failureResponse, RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
                }
            }, exception -> {
                String failureResponse = "Something went wrong while fetching resource sharing record for resource_id: " + resourceId + " and source_idx: " + resourceIndex + " from " + resourceSharingIndex;
                LOGGER.error(failureResponse, (Throwable)exception);
                listener.onFailure((Exception)new OpenSearchStatusException(failureResponse, RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
            }));
        }
    }

    public void share(String resourceId, String resourceIndex, ShareWith shareWith, ActionListener<ResourceSharing> listener) {
        StepListener sharingInfoListener = new StepListener();
        this.fetchSharingInfo(resourceIndex, resourceId, (ActionListener<ResourceSharing>)sharingInfoListener);
        sharingInfoListener.whenComplete(sharingInfo -> {
            if (sharingInfo == null) {
                LOGGER.debug("No sharing record found for resource {}", (Object)resourceId);
                listener.onResponse(null);
                return;
            }
            for (String accessLevel : shareWith.accessLevels()) {
                Recipients target = shareWith.atAccessLevel(accessLevel);
                sharingInfo.share(accessLevel, target);
            }
            String resourceSharingIndex = ResourceSharingIndexHandler.getSharingIndex(resourceIndex);
            try (ThreadContext.StoredContext ctx = this.threadPool.getThreadContext().stashContext();){
                IndexRequest ir = (IndexRequest)((IndexRequestBuilder)this.client.prepareIndex(resourceSharingIndex).setId(sharingInfo.getResourceId()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).setSource(sharingInfo.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS)).setOpType(DocWriteRequest.OpType.INDEX).request();
                ActionListener irListener = ActionListener.wrap(idxResponse -> {
                    ctx.restore();
                    LOGGER.info("Successfully updated {} entry for resource {} in index {}.", (Object)resourceSharingIndex, (Object)resourceId, (Object)resourceIndex);
                    listener.onResponse(sharingInfo);
                }, failResponse -> {
                    LOGGER.error(failResponse.getMessage());
                    listener.onFailure(failResponse);
                });
                this.client.index(ir, irListener);
            }
        }, arg_0 -> listener.onFailure(arg_0));
    }

    public void revoke(String resourceId, String resourceIndex, ShareWith revokeAccess, ActionListener<ResourceSharing> listener) {
        if (StringUtils.isBlank((CharSequence)resourceId) || StringUtils.isBlank((CharSequence)resourceIndex) || revokeAccess == null) {
            listener.onFailure((Exception)new IllegalArgumentException("resourceId, resourceIndex, and revokeAccess must not be null or empty"));
            return;
        }
        String resourceSharingIndex = ResourceSharingIndexHandler.getSharingIndex(resourceIndex);
        StepListener sharingInfoListener = new StepListener();
        this.fetchSharingInfo(resourceIndex, resourceId, (ActionListener<ResourceSharing>)sharingInfoListener);
        sharingInfoListener.whenComplete(sharingInfo -> {
            assert (sharingInfo != null);
            for (String accessLevel : revokeAccess.accessLevels()) {
                Recipients target = revokeAccess.atAccessLevel(accessLevel);
                LOGGER.debug("Revoking access for resource {} in {} for entities: {} and accessLevel: {}", (Object)resourceId, (Object)resourceIndex, (Object)target, (Object)accessLevel);
                sharingInfo.revoke(accessLevel, target);
            }
            try (ThreadContext.StoredContext ctx = this.threadPool.getThreadContext().stashContext();){
                IndexRequest ir = (IndexRequest)((IndexRequestBuilder)this.client.prepareIndex(resourceSharingIndex).setId(sharingInfo.getResourceId()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).setSource(sharingInfo.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS)).setOpType(DocWriteRequest.OpType.INDEX).request();
                ActionListener irListener = ActionListener.wrap(idxResponse -> {
                    ctx.restore();
                    LOGGER.info("Successfully revoked access of {} to resource {} in index {}.", (Object)revokeAccess, (Object)resourceId, (Object)resourceIndex);
                    listener.onResponse(sharingInfo);
                }, failResponse -> {
                    LOGGER.error(failResponse.getMessage());
                    listener.onFailure(failResponse);
                });
                this.client.index(ir, irListener);
            }
        }, arg_0 -> listener.onFailure(arg_0));
    }

    public void patchSharingInfo(String resourceId, String resourceIndex, ShareWith add, ShareWith revoke, ActionListener<ResourceSharing> listener) {
        StepListener sharingInfoListener = new StepListener();
        String resourceSharingIndex = ResourceSharingIndexHandler.getSharingIndex(resourceIndex);
        this.fetchSharingInfo(resourceIndex, resourceId, (ActionListener<ResourceSharing>)sharingInfoListener);
        sharingInfoListener.whenComplete(resourceSharing -> {
            ShareWith updatedShareWith = resourceSharing.getShareWith();
            if (updatedShareWith == null) {
                updatedShareWith = new ShareWith(new HashMap());
            }
            if (add != null) {
                updatedShareWith = updatedShareWith.add(add);
            }
            if (revoke != null) {
                updatedShareWith = updatedShareWith.revoke(revoke);
            }
            ResourceSharing updatedSharingInfo = new ResourceSharing(resourceId, resourceSharing.getCreatedBy(), updatedShareWith);
            try (ThreadContext.StoredContext ctx = this.threadPool.getThreadContext().stashContext();){
                IndexRequest ir = (IndexRequest)((IndexRequestBuilder)this.client.prepareIndex(resourceSharingIndex).setId(resourceId).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).setSource(updatedSharingInfo.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS)).setOpType(DocWriteRequest.OpType.INDEX).request();
                this.client.index(ir, ActionListener.wrap(idxResponse -> {
                    ctx.restore();
                    LOGGER.info("Successfully updated {} resource sharing info for resource {} in index {}.", (Object)resourceSharingIndex, (Object)resourceId, (Object)resourceIndex);
                    listener.onResponse((Object)updatedSharingInfo);
                }, e -> {
                    LOGGER.error(e.getMessage());
                    listener.onFailure(e);
                }));
            }
        }, arg_0 -> listener.onFailure(arg_0));
    }

    public void deleteResourceSharingRecord(String resourceId, String resourceIndex, ActionListener<Boolean> listener) {
        String resourceSharingIndex = ResourceSharingIndexHandler.getSharingIndex(resourceIndex);
        LOGGER.debug("Deleting documents asynchronously from {} where source_idx = {} and resource_id = {}", (Object)resourceSharingIndex, (Object)resourceIndex, (Object)resourceId);
        try (ThreadContext.StoredContext ctx = this.threadPool.getThreadContext().stashContext();){
            DeleteRequest deleteRequest = new DeleteRequest(resourceSharingIndex, resourceId);
            this.client.delete(deleteRequest, ActionListener.wrap(deleteResponse -> {
                ctx.restore();
                boolean deleted = DocWriteResponse.Result.DELETED.equals((Object)deleteResponse.getResult());
                if (deleted) {
                    LOGGER.debug("Successfully deleted {} documents from {}", (Object)deleted, (Object)resourceSharingIndex);
                    listener.onResponse((Object)true);
                } else {
                    LOGGER.debug("No documents found to delete in {} for source_idx: {} and resource_id: {}", (Object)resourceSharingIndex, (Object)resourceIndex, (Object)resourceId);
                    listener.onResponse((Object)false);
                }
            }, failResponse -> {
                LOGGER.error("Failed to delete documents from {}", (Object)resourceSharingIndex, failResponse);
                listener.onFailure(failResponse);
            }));
        }
    }

    private void executeSearchRequest(Scroll scroll, SearchRequest searchRequest, AbstractQueryBuilder<? extends AbstractQueryBuilder<?>> query, ActionListener<Set<String>> listener) {
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query(query).size(1000).fetchSource(new String[]{"resource_id"}, null);
        searchRequest.source(searchSourceBuilder);
        StepListener searchStep = new StepListener();
        this.client.search(searchRequest, (ActionListener)searchStep);
        searchStep.whenComplete(initialResponse -> {
            HashSet<String> collectedResourceIds = new HashSet<String>();
            String scrollId = initialResponse.getScrollId();
            this.processScrollResults(collectedResourceIds, scroll, scrollId, initialResponse.getHits().getHits(), listener);
        }, arg_0 -> listener.onFailure(arg_0));
    }

    private void executeFlattenedSearchRequest(Scroll scroll, SearchRequest searchRequest, BoolQueryBuilder filterQuery, ActionListener<Set<String>> listener) {
        String scriptSource = "    // handle shared\n    if (params._source.share_with instanceof Map) {\n      for (def grp : params._source.share_with.values()) {\n        if (grp.users instanceof List) {\n          for (u in grp.users) {\n            emit(\"user:\" + u);\n          }\n        }\n        if (grp.roles instanceof List) {\n          for (r in grp.roles) {\n            emit(\"role:\" + r);\n          }\n        }\n        if (grp.backend_roles instanceof List) {\n          for (b in grp.backend_roles) {\n            emit(\"backend:\" + b);\n          }\n        }\n      }\n    }\n";
        Script script = new Script(ScriptType.INLINE, "painless", scriptSource, Map.of());
        SearchSourceBuilder ssb = new SearchSourceBuilder().derivedField("all_shared_principals", "keyword", script).query((QueryBuilder)filterQuery).size(1000).fetchSource(new String[]{"resource_id"}, null);
        searchRequest.source(ssb);
        StepListener searchStep = new StepListener();
        this.client.search(searchRequest, (ActionListener)searchStep);
        searchStep.whenComplete(initialResponse -> {
            HashSet<String> collectedResourceIds = new HashSet<String>();
            String scrollId = initialResponse.getScrollId();
            this.processScrollResults(collectedResourceIds, scroll, scrollId, initialResponse.getHits().getHits(), listener);
        }, arg_0 -> listener.onFailure(arg_0));
    }

    private void processScrollResults(Set<String> collectedResourceIds, Scroll scroll, String scrollId, SearchHit[] hits, ActionListener<Set<String>> listener) {
        block4: {
            block3: {
                if (hits == null) break block3;
                if (hits.length != 0) break block4;
            }
            this.clearScroll(scrollId, (ActionListener<Void>)ActionListener.wrap(ignored -> listener.onResponse((Object)collectedResourceIds), arg_0 -> listener.onFailure(arg_0)));
            return;
        }
        for (SearchHit hit : hits) {
            Map source = hit.getSourceAsMap();
            if (source == null || !source.containsKey("resource_id")) continue;
            collectedResourceIds.add(source.get("resource_id").toString());
        }
        SearchScrollRequest scrollRequest = new SearchScrollRequest(scrollId).scroll(scroll);
        this.client.searchScroll(scrollRequest, ActionListener.wrap(scrollResponse -> this.processScrollResults(collectedResourceIds, scroll, scrollResponse.getScrollId(), scrollResponse.getHits().getHits(), listener), e -> this.clearScroll(scrollId, (ActionListener<Void>)ActionListener.wrap(ignored -> listener.onFailure(e), ex -> {
            e.addSuppressed((Throwable)ex);
            listener.onFailure(e);
        }))));
    }

    private void clearScroll(String scrollId, ActionListener<Void> listener) {
        if (scrollId == null) {
            listener.onResponse(null);
            return;
        }
        ClearScrollRequest clearScrollRequest = new ClearScrollRequest();
        clearScrollRequest.addScrollId(scrollId);
        this.client.clearScroll(clearScrollRequest, ActionListener.wrap(r -> listener.onResponse(null), e -> {
            LOGGER.warn("Failed to clear scroll context", (Throwable)e);
            listener.onResponse(null);
        }));
    }
}

