/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.salt.factory;

import java.util.Arrays;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.klimt.font.UFont;
import net.sourceforge.plantuml.salt.DataSource;
import net.sourceforge.plantuml.salt.Terminated;
import net.sourceforge.plantuml.salt.element.Element;
import net.sourceforge.plantuml.salt.element.ElementText;
import net.sourceforge.plantuml.salt.factory.ElementFactory;
import net.sourceforge.plantuml.style.ISkinSimple;

public class ElementFactoryText
implements ElementFactory {
    private final DataSource dataSource;
    private final ISkinSimple spriteContainer;

    public ElementFactoryText(DataSource dataSource, ISkinSimple spriteContainer) {
        this.dataSource = dataSource;
        this.spriteContainer = spriteContainer;
    }

    @Override
    public Terminated<Element> create() {
        if (!this.ready()) {
            throw new IllegalStateException();
        }
        Terminated next = (Terminated)this.dataSource.next();
        String text = (String)next.getElement();
        UFont font = UFont.byDefault(12);
        return new Terminated<Element>(new ElementText(Arrays.asList(text), font, this.spriteContainer), next.getTerminator());
    }

    @Override
    public boolean ready() {
        String text = this.dataSource.peek(0).getElement();
        if (text.startsWith("{") || text.startsWith("}")) {
            return false;
        }
        return StringUtils.trin(text).length() > 0;
    }
}

