/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.configurable;

import com.intellij.application.options.colors.fileStatus.FileStatusColorsConfigurable;
import com.intellij.openapi.extensions.BaseExtensionPointName;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableEP;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.options.ex.Weighted;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfigurableProvider;
import com.intellij.openapi.vcs.changes.conflicts.ChangelistConflictConfigurable;
import com.intellij.openapi.vcs.changes.ui.IgnoredSettingsPanel;
import com.intellij.openapi.vcs.configurable.CommitDialogConfigurable;
import com.intellij.openapi.vcs.configurable.IssueNavigationConfigurable;
import com.intellij.openapi.vcs.configurable.ShelfProjectConfigurable;
import com.intellij.openapi.vcs.configurable.VcsGeneralSettingsConfigurable;
import com.intellij.openapi.vcs.configurable.VcsMappingConfigurable;
import com.intellij.openapi.vcs.impl.VcsEP;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class VcsManagerConfigurable
extends SearchableConfigurable.Parent.Abstract
implements Weighted,
ConfigurableGroup,
Configurable.NoScroll,
Configurable.WithEpDependencies {
    private static final String ID = "project.propVCSSupport.Mappings";
    private static final int GROUP_WEIGHT = 45;
    @NotNull
    private final Project myProject;

    public VcsManagerConfigurable(@NotNull Project project) {
        if (project == null) {
            VcsManagerConfigurable.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @NonNls
    @NotNull
    public String getId() {
        return ID;
    }

    @NonNls
    public String getHelpTopic() {
        return ID;
    }

    public int getWeight() {
        return 45;
    }

    @NlsContexts.ConfigurableName
    public String getDisplayName() {
        return VcsBundle.message((String)"version.control.main.configurable.name", (Object[])new Object[0]);
    }

    @NlsContexts.DetailedDescription
    public String getDescription() {
        return VcsBundle.message((String)"version.control.main.configurable.description", (Object[])new Object[0]);
    }

    @NotNull
    public Collection<BaseExtensionPointName<?>> getDependencies() {
        List<BaseExtensionPointName<?>> list = Arrays.asList(VcsEP.EP_NAME, VcsConfigurableProvider.EP_NAME);
        if (list == null) {
            VcsManagerConfigurable.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    protected @NotNull Configurable @NotNull [] buildConfigurables() {
        ArrayList<Object> result2 = new ArrayList<Object>();
        result2.add((Object)new VcsGeneralSettingsConfigurable(this.myProject));
        result2.add(new VcsMappingConfigurable(this.myProject));
        if (Registry.is((String)"vcs.ignorefile.generation", (boolean)true)) {
            result2.add((Object)new IgnoredSettingsPanel(this.myProject));
        }
        result2.add((Object)new IssueNavigationConfigurable(this.myProject));
        result2.add((Object)new ChangelistConflictConfigurable(this.myProject));
        result2.add((Object)new CommitDialogConfigurable(this.myProject));
        result2.add((Object)new ShelfProjectConfigurable(this.myProject));
        for (VcsConfigurableProvider provider : VcsConfigurableProvider.EP_NAME.getExtensionList()) {
            ContainerUtil.addIfNotNull(result2, (Object)provider.getConfigurable(this.myProject));
        }
        result2.add(new FileStatusColorsConfigurable());
        for (AbstractVcs vcs : ProjectLevelVcsManager.getInstance((Project)this.myProject).getAllSupportedVcss()) {
            Configurable configurable = vcs.getConfigurable();
            if (configurable == null) continue;
            result2.add((Configurable)ConfigurableWrapper.wrapConfigurable((ConfigurableEP)new VcsConfigurableEP(this.myProject, vcs, configurable)));
        }
        Configurable[] configurableArray = result2.toArray(new Configurable[0]);
        if (configurableArray == null) {
            VcsManagerConfigurable.$$$reportNull$$$0(2);
        }
        return configurableArray;
    }

    @NotNull
    @NonNls
    private static String getVcsConfigurableId(@NotNull String vcsName) {
        if (vcsName == null) {
            VcsManagerConfigurable.$$$reportNull$$$0(3);
        }
        String string = "vcs." + vcsName;
        if (string == null) {
            VcsManagerConfigurable.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/configurable/VcsManagerConfigurable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/configurable/VcsManagerConfigurable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildConfigurables";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getVcsConfigurableId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getVcsConfigurableId";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 4 -> new IllegalStateException(string);
        };
    }

    private static class VcsConfigurableEP
    extends ConfigurableEP<Configurable> {
        private static final int WEIGHT = -500;
        private final Configurable myConfigurable;

        VcsConfigurableEP(@NotNull Project project, @NotNull AbstractVcs vcs, @NonNls Configurable configurable) {
            if (project == null) {
                VcsConfigurableEP.$$$reportNull$$$0(0);
            }
            if (vcs == null) {
                VcsConfigurableEP.$$$reportNull$$$0(1);
            }
            super(project);
            this.myConfigurable = configurable;
            this.displayName = vcs.getDisplayName();
            this.id = VcsManagerConfigurable.getVcsConfigurableId(vcs.getName());
            this.groupWeight = -500;
        }

        @NotNull
        protected ConfigurableEP.ObjectProducer createProducer() {
            return new ConfigurableEP.ObjectProducer(){

                protected Object createElement() {
                    return myConfigurable;
                }

                protected boolean canCreateElement() {
                    return true;
                }

                protected Class<?> getType() {
                    return SearchableConfigurable.class;
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "vcs";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vcs/configurable/VcsManagerConfigurable$VcsConfigurableEP";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

