/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.ast;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.ast.PyAstAnnotation;
import com.jetbrains.python.ast.PyAstAnnotationOwner;
import com.jetbrains.python.ast.PyAstElementKt;
import com.jetbrains.python.ast.PyAstElementVisitor;
import com.jetbrains.python.ast.PyAstExpression;
import com.jetbrains.python.ast.PyAstNamedElementContainer;
import com.jetbrains.python.ast.PyAstParenthesizedExpression;
import com.jetbrains.python.ast.PyAstQualifiedExpression;
import com.jetbrains.python.ast.PyAstReferenceExpression;
import com.jetbrains.python.ast.PyAstSequenceExpression;
import com.jetbrains.python.ast.PyAstStarExpression;
import com.jetbrains.python.ast.PyAstStatement;
import com.jetbrains.python.ast.PyAstSubscriptionExpression;
import com.jetbrains.python.ast.PyAstTargetExpression;
import com.jetbrains.python.ast.PyAstTupleExpression;
import com.jetbrains.python.ast.impl.PyPsiUtilsCore;
import com.jetbrains.python.ast.impl.PyUtilCore;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAstElementGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public interface PyAstAssignmentStatement
extends PyAstStatement,
PyAstNamedElementContainer,
PyAstAnnotationOwner {
    @ApiStatus.Internal
    public static <T extends PyAstExpression> T @NotNull [] calcTargets(@NotNull PyAstAssignmentStatement statement, boolean raw, T @NotNull [] result2) {
        ASTNode[] eqSigns;
        if (statement == null) {
            PyAstAssignmentStatement.$$$reportNull$$$0(0);
        }
        if (result2 == null) {
            PyAstAssignmentStatement.$$$reportNull$$$0(1);
        }
        if ((eqSigns = statement.getNode().getChildren(TokenSet.create((IElementType[])new IElementType[]{PyTokenTypes.EQ}))).length == 0) {
            if (result2 == null) {
                PyAstAssignmentStatement.$$$reportNull$$$0(2);
            }
            return result2;
        }
        ASTNode lastEq = eqSigns[eqSigns.length - 1];
        ArrayList<PyAstExpression> candidates = new ArrayList<PyAstExpression>();
        for (ASTNode node = statement.getNode().getFirstChildNode(); node != null && node != lastEq; node = node.getTreeNext()) {
            PsiElement psi = node.getPsi();
            if (!(psi instanceof PyAstExpression)) continue;
            PyAstExpression expression = (PyAstExpression)psi;
            if (raw) {
                candidates.add(expression);
                continue;
            }
            PyAstAssignmentStatement.addCandidate(candidates, expression);
        }
        ArrayList<PyAstExpression> targets = new ArrayList<PyAstExpression>();
        for (PyAstExpression expr : candidates) {
            if (!raw && !(expr instanceof PyAstTargetExpression) && !(expr instanceof PyAstReferenceExpression) && !(expr instanceof PyAstSubscriptionExpression)) continue;
            targets.add(expr);
        }
        PyAstExpression[] pyAstExpressionArray = (PyAstExpression[])targets.toArray(result2);
        if (pyAstExpressionArray == null) {
            PyAstAssignmentStatement.$$$reportNull$$$0(3);
        }
        return pyAstExpressionArray;
    }

    private static void addCandidate(List<PyAstExpression> candidates, PyAstExpression psi) {
        if (psi instanceof PyAstParenthesizedExpression) {
            PyAstParenthesizedExpression parenthesizedExpression = (PyAstParenthesizedExpression)psi;
            PyAstAssignmentStatement.addCandidate(candidates, parenthesizedExpression.getContainedExpression());
        } else if (psi instanceof PyAstSequenceExpression) {
            PyAstSequenceExpression sequenceExpression = (PyAstSequenceExpression)psi;
            for (PyAstExpression pyExpression : sequenceExpression.getElements()) {
                PyAstAssignmentStatement.addCandidate(candidates, pyExpression);
            }
        } else if (psi instanceof PyAstStarExpression) {
            PyAstStarExpression starExpression = (PyAstStarExpression)psi;
            PyAstExpression expression = starExpression.getExpression();
            if (expression != null) {
                PyAstAssignmentStatement.addCandidate(candidates, expression);
            }
        } else {
            candidates.add(psi);
        }
    }

    @Override
    @Nullable
    default public PyAstAnnotation getAnnotation() {
        return PyAstElementKt.findChildByClass(this, PyAstAnnotation.class);
    }

    public PyAstExpression @NotNull [] getTargets();

    public PyAstExpression @NotNull [] getRawTargets();

    @Nullable
    default public PyAstExpression getAssignedValue() {
        PsiElement child;
        for (child = this.getLastChild(); child != null && !(child instanceof PyAstExpression); child = child.getPrevSibling()) {
            if (!(child instanceof PsiErrorElement)) continue;
            return null;
        }
        return (PyAstExpression)child;
    }

    @NotNull
    default public List<? extends Pair<? extends PyAstExpression, ? extends PyAstExpression>> getTargetsToValuesMapping() {
        PyAstExpression[] constituents;
        SmartList ret = new SmartList();
        if (!PsiTreeUtil.hasErrorElements((PsiElement)this) && (constituents = (PyAstExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)this, PyAstExpression.class)) != null && constituents.length > 1) {
            int lastIndex = constituents.length - 1;
            PyAstExpression rhs = constituents[lastIndex];
            for (int i = 0; i < lastIndex; ++i) {
                PyAstAssignmentStatement.mapToValues(constituents[i], rhs, (List<Pair<PyAstExpression, PyAstExpression>>)ret);
            }
        }
        SmartList smartList = ret;
        if (smartList == null) {
            PyAstAssignmentStatement.$$$reportNull$$$0(4);
        }
        return smartList;
    }

    private static void mapToValues(@Nullable PyAstExpression lhs, @Nullable PyAstExpression rhs, List<Pair<PyAstExpression, PyAstExpression>> map2) {
        block11: {
            PyAstTupleExpression rhs_tuple;
            PyAstTupleExpression lhs_tuple;
            block12: {
                PyAstExpression rhs_one;
                block10: {
                    lhs_tuple = null;
                    PyAstExpression lhs_one = null;
                    PyAstExpression pyAstExpression = PyPsiUtilsCore.flattenParens(lhs);
                    if (pyAstExpression instanceof PyAstTupleExpression) {
                        PyAstTupleExpression tupleExpr;
                        lhs_tuple = tupleExpr = (PyAstTupleExpression)pyAstExpression;
                    } else if (lhs != null) {
                        lhs_one = lhs;
                    }
                    rhs_tuple = null;
                    rhs_one = null;
                    PyAstExpression pyAstExpression2 = PyPsiUtilsCore.flattenParens(rhs);
                    if (pyAstExpression2 instanceof PyAstTupleExpression) {
                        PyAstTupleExpression tupleExpr;
                        rhs_tuple = tupleExpr = (PyAstTupleExpression)pyAstExpression2;
                    } else if (rhs != null) {
                        rhs_one = rhs;
                    }
                    if (lhs_one == null) break block10;
                    map2.add((Pair<PyAstExpression, PyAstExpression>)Pair.create((Object)lhs_one, (Object)rhs));
                    break block11;
                }
                if (lhs_tuple == null || rhs_one == null) break block12;
                PyAstElementGenerator elementGenerator = PyAstElementGenerator.getInstance(rhs_one.getProject());
                LanguageLevel languageLevel = LanguageLevel.forElement((PsiElement)lhs);
                int counter = 0;
                for (PyAstExpression tuple_elt : lhs_tuple.getElements()) {
                    try {
                        PyAstExpression expression = elementGenerator.createExpressionFromText(languageLevel, "(" + rhs_one.getText() + ")[" + counter + "]");
                        PyAstAssignmentStatement.mapToValues(tuple_elt, expression, map2);
                    }
                    catch (IncorrectOperationException incorrectOperationException) {
                        // empty catch block
                    }
                    ++counter;
                }
                break block11;
            }
            if (lhs_tuple == null || rhs_tuple == null) break block11;
            List<PyAstExpression> lhsTupleElements = Arrays.asList(lhs_tuple.getElements());
            List<PyAstExpression> rhsTupleElements = Arrays.asList(rhs_tuple.getElements());
            int size = Math.max(lhsTupleElements.size(), rhsTupleElements.size());
            for (int index = 0; index < size; ++index) {
                PyAstAssignmentStatement.mapToValues((PyAstExpression)ContainerUtil.getOrElse(lhsTupleElements, (int)index, null), (PyAstExpression)ContainerUtil.getOrElse(rhsTupleElements, (int)index, null), map2);
            }
        }
    }

    @Nullable
    default public PyAstExpression getLeftHandSideExpression() {
        PsiElement child;
        for (child = this.getFirstChild(); child != null && !(child instanceof PyAstExpression); child = child.getPrevSibling()) {
            if (!(child instanceof PsiErrorElement)) continue;
            return null;
        }
        return (PyAstExpression)child;
    }

    default public boolean isAssignmentTo(@NotNull String name2) {
        PyAstExpression lhs;
        if (name2 == null) {
            PyAstAssignmentStatement.$$$reportNull$$$0(5);
        }
        return (lhs = this.getLeftHandSideExpression()) instanceof PyAstTargetExpression && name2.equals(lhs.getName());
    }

    @Override
    @NotNull
    default public List<PsiNamedElement> getNamedElements() {
        List<PyAstExpression> expressions = PyUtilCore.flattenedParensAndStars(this.getTargets());
        ArrayList<PsiNamedElement> result2 = new ArrayList<PsiNamedElement>();
        for (PyAstExpression expression : expressions) {
            if (expression instanceof PyAstQualifiedExpression && ((PyAstQualifiedExpression)expression).isQualified() || !(expression instanceof PsiNamedElement)) continue;
            result2.add((PsiNamedElement)expression);
        }
        ArrayList<PsiNamedElement> arrayList = result2;
        if (arrayList == null) {
            PyAstAssignmentStatement.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @Override
    default public void acceptPyVisitor(PyAstElementVisitor pyVisitor) {
        pyVisitor.visitPyAssignmentStatement(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/ast/PyAstAssignmentStatement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/ast/PyAstAssignmentStatement";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "calcTargets";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetsToValuesMapping";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamedElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "calcTargets";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAssignmentTo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 6 -> new IllegalStateException(string);
        };
    }
}

