/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.application.AccessToken;
import com.intellij.util.ThrowableRunnable;
import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

public class LoggedErrorProcessor {
    private static volatile LoggedErrorProcessor ourInstance = new LoggedErrorProcessor();

    @NotNull
    static LoggedErrorProcessor getInstance() {
        LoggedErrorProcessor loggedErrorProcessor = ourInstance;
        if (loggedErrorProcessor == null) {
            LoggedErrorProcessor.$$$reportNull$$$0(0);
        }
        return loggedErrorProcessor;
    }

    public static <T extends Throwable> void executeWith(@NotNull LoggedErrorProcessor newInstance, @NotNull ThrowableRunnable<T> runnable) throws T {
        if (newInstance == null) {
            LoggedErrorProcessor.$$$reportNull$$$0(1);
        }
        if (runnable == null) {
            LoggedErrorProcessor.$$$reportNull$$$0(2);
        }
        LoggedErrorProcessor oldInstance = LoggedErrorProcessor.getInstance();
        ourInstance = newInstance;
        try {
            runnable.run();
        }
        finally {
            ourInstance = oldInstance;
        }
    }

    @NotNull
    public static AccessToken executeWith(@NotNull LoggedErrorProcessor newInstance) {
        if (newInstance == null) {
            LoggedErrorProcessor.$$$reportNull$$$0(3);
        }
        final LoggedErrorProcessor oldInstance = LoggedErrorProcessor.getInstance();
        ourInstance = newInstance;
        return new AccessToken(){

            public void finish() {
                ourInstance = oldInstance;
            }
        };
    }

    @NotNull
    public static Throwable executeAndReturnLoggedError(@NotNull Runnable runnable) {
        if (runnable == null) {
            LoggedErrorProcessor.$$$reportNull$$$0(4);
        }
        final AtomicReference error = new AtomicReference();
        LoggedErrorProcessor.executeWith(new LoggedErrorProcessor(){

            @Override
            @NotNull
            public Set<Action> processError(@NotNull String category, @NotNull String message, String @NotNull [] details, @Nullable Throwable t) {
                if (category == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (message == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (details == null) {
                    2.$$$reportNull$$$0(2);
                }
                Assert.assertNotNull((String)("Unexpected error without Throwable: " + message), (Object)t);
                if (!error.compareAndSet(null, t)) {
                    Assert.fail((String)("Multiple errors were reported: " + ((Throwable)error.get()).getMessage() + " and " + t.getMessage()));
                }
                EnumSet<Action> enumSet = Action.NONE;
                if (enumSet == null) {
                    2.$$$reportNull$$$0(3);
                }
                return enumSet;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 3 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "category";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "message";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "details";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/testFramework/LoggedErrorProcessor$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/testFramework/LoggedErrorProcessor$2";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "processError";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "processError";
                        break;
                    }
                    case 3: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 3 -> new IllegalStateException(string);
                };
            }
        }, () -> runnable.run());
        Throwable result = (Throwable)error.get();
        Assert.assertNotNull((String)"No errors were logged", (Object)result);
        Throwable throwable = result;
        if (throwable == null) {
            LoggedErrorProcessor.$$$reportNull$$$0(5);
        }
        return throwable;
    }

    public boolean processWarn(@NotNull String category, @NotNull String message, @Nullable Throwable t) {
        if (category == null) {
            LoggedErrorProcessor.$$$reportNull$$$0(6);
        }
        if (message == null) {
            LoggedErrorProcessor.$$$reportNull$$$0(7);
        }
        return true;
    }

    @NotNull
    public Set<Action> processError(@NotNull String category, @NotNull String message, String @NotNull [] details, @Nullable Throwable t) {
        if (category == null) {
            LoggedErrorProcessor.$$$reportNull$$$0(8);
        }
        if (message == null) {
            LoggedErrorProcessor.$$$reportNull$$$0(9);
        }
        if (details == null) {
            LoggedErrorProcessor.$$$reportNull$$$0(10);
        }
        EnumSet<Action> enumSet = Action.ALL;
        if (enumSet == null) {
            LoggedErrorProcessor.$$$reportNull$$$0(11);
        }
        return enumSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 6, 7, 8, 9, 10 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/LoggedErrorProcessor";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newInstance";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "details";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/LoggedErrorProcessor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "executeAndReturnLoggedError";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "processError";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "executeWith";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "executeAndReturnLoggedError";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processWarn";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processError";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 6, 7, 8, 9, 10 -> new IllegalArgumentException(string);
        };
    }

    public static enum Action {
        LOG,
        STDERR,
        RETHROW;

        public static final EnumSet<Action> ALL;
        public static final EnumSet<Action> NONE;

        static {
            ALL = EnumSet.allOf(Action.class);
            NONE = EnumSet.noneOf(Action.class);
        }
    }
}

