\name{OrImageFilter}
\alias{OrImageFilter}
\title{OrImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Implements the OR bitwise operator pixel-wise between two images.
OrImageFilter}
\details{
This class is templated over the types of the two input images and the
type of the output image. Numeric conversions (castings) are done by
the C++ defaults.
Since the bitwise OR operation is only defined in C++ for integer
types, the images passed to this filter must comply with the
requirement of using integer pixel type.
The total operation over one pixel will be
Where "|" is the boolean OR operator in C++.
See:
Or for the procedural interface
itk::OrImageFilter for the Doxygen on the original ITK class.
OrImageFilter}
%C++ includes: sitkOrImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1, const Image &image2):}{}
\item{Image Execute(const Image &image1, int constant):}{
Execute the filter with an image and a constant
}
\item{Image Execute(Image &&image1, const Image &image2):}{
Execute the filter on the input images
}
\item{Image Execute(Image &&image1, int constant):}{}
\item{Image Execute(int constant, const Image &image2):}{}
\item{std::string GetName() const:}{
Name of this class
}
\item{ OrImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~OrImageFilter():}{
Destructor
}
}
}
